package memory

import "code.justin.tv/extensions/discovery/data/model"

func (s *store) GetCarouselEntriesByCarouselIDs(ids []string) ([][]*model.FeaturedCarouselEntry, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	entries := [][]*model.FeaturedCarouselEntry{}
	for _, val := range ids {
		carouselEntries, ok := s.carouselsToEntries[val]
		if ok {
			carouselEntries = []*model.FeaturedCarouselEntry{}
		}
		entries = append(entries, carouselEntries)
	}

	return entries, nil
}
