package memory

import "code.justin.tv/extensions/discovery/data/model"

func (s *store) GetCarouselsByScheduleIDs(scheduleIDs []string) ([]*model.FeaturedCarousel, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	carousels := []*model.FeaturedCarousel{}
	for _, val := range scheduleIDs {
		carousel, ok := s.scheduleIDsToCarousels[val]
		if ok {
			carousels = append(carousels, carousel)
		}
	}

	return carousels, nil
}
