package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) GetCategory(req *discovery.GetCategoryRequest) (*model.Category, *model.CategoryTranslation, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	defaultLanguageCode, err := s.getOrCreateLanguageCode(model.DefaultCategoryLanguageCode)
	if err != nil {
		return nil, nil, err
	}

	languageCode, err := s.getOrCreateLanguageCode(req.GetLanguage())
	if err != nil {
		return nil, nil, err
	}

	cat, ok := s.categories[req.GetCategoryID()]
	if !ok {
		cat, ok = s.categoriesBySlug[req.GetCategoryID()]
		if !ok {
			return nil, nil, data.ErrNotFound
		}
	}

	var translation *model.CategoryTranslation
	translationMap, ok := s.translations[req.GetCategoryID()]
	if ok {
		translation, ok = translationMap[languageCode.ID]
		if !ok {
			translation = translationMap[defaultLanguageCode.ID]
		}
	}

	return cat, translation, nil
}
