package memory

import (
	"time"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) GetCurrentCarousel(req *discovery.GetFeaturedScheduleRequest) (*model.FeaturedCarousel, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	_, ok := s.featuredCarouselSchedules[req.GetScheduleID()]
	if !ok {
		return nil, data.ErrNotFound
	}

	now := time.Now()
	mostRecentTime := time.Time{} // zero time
	var mostRecentCarousel *model.FeaturedCarousel

	for _, carousel := range s.featuredCarousels {
		if carousel.ScheduleID == req.GetScheduleID() && carousel.StartTime.Before(now) && carousel.StartTime.After(mostRecentTime) {
			mostRecentTime = carousel.StartTime
			mostRecentCarousel = carousel
		}
	}

	return mostRecentCarousel, nil
}
