package memory

import (
	"sort"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) GetEntriesForCarousel(req *discovery.GetFeaturedCarouselRequest) ([]*model.FeaturedCarouselEntry, error) {
	entries, ok := s.carouselsToEntries[req.GetCarouselID()]
	if !ok {
		return []*model.FeaturedCarouselEntry{}, nil
	}

	sort.Slice(entries, func(i, j int) bool {
		return entries[i].Order < entries[j].Order
	})

	return entries, nil
}
