package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) GetDiscoveryData(req *discovery.GetExtensionVersionDiscoveryDataRequest) (*model.ExtensionDiscoveryData, error) {
	discoData, err := s.AdminGetDiscoveryData(req)
	if err != nil {
		return nil, err
	}

	// Non-admin soft delete check - deleted at not being zero means it was soft deleted
	// and should not be returned
	if !discoData.DeletedAt.IsZero() {
		return nil, data.ErrNotFound
	}

	return discoData, nil
}
