package memory

import (
	"sort"
	"time"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) GetExtensionsForCategory(req *discovery.GetCategoryExtensionsRequest) ([]*model.CuratedCategoryExtension, int32, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	var models []*model.CuratedCategoryExtension

	category, ok := s.categories[req.GetCategoryID()]
	if !ok {
		// TODO - this return fine?
		return models, 0, nil
	}

	offset := int(req.GetOffset())
	limit := int(req.GetLimit())

	exts, ok := s.categoriesToExtensions[req.GetCategoryID()]
	if ok {
		if category.SortKey == model.CategorySortkeyManual {
			sort.Slice(exts, func(i, j int) bool {
				return exts[i].Order < exts[j].Order
			})
		}

		if category.SortKey == model.CategorySortkeyTime {
			sort.Slice(exts, func(i, j int) bool {
				return exts[i].StartTime.After(*exts[j].StartTime)
			})

			extsBeforeNow := make([]*model.CuratedCategoryExtension, 0, len(exts))
			for i := 0; i < len(exts); i++ {
				if exts[i].StartTime.Before(time.Now()) {
					extsBeforeNow = append(extsBeforeNow, exts[i])
				}
			}

			exts = extsBeforeNow
		}

		for i := offset; (len(models) < limit || limit == -1) && i < len(exts); i++ {
			models = append(models, &model.CuratedCategoryExtension{
				CategoryID:  req.GetCategoryID(),
				ExtensionID: exts[i].ExtensionID,
			})
		}
	}

	return models, int32(len(exts)), nil
}
