package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) GetFeaturedCarousel(req *discovery.GetFeaturedCarouselRequest) (*model.FeaturedCarousel, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	carousel, ok := s.featuredCarousels[req.GetCarouselID()]
	if !ok {
		return nil, data.ErrNotFound
	}

	return carousel, nil
}
