package memory

import (
	"sort"
	"strings"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) GetFeaturedCarouselEntries(req *discovery.GetFeaturedCarouselEntriesRequest) ([]*model.FeaturedCarouselEntry, int32, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	allEntries := []*model.FeaturedCarouselEntry{}
	for _, val := range s.featuredCarouselEntries {
		allEntries = append(allEntries, val)
	}

	numEntries := len(allEntries)

	offset := int(req.GetOffset())
	limit := int(req.GetLimit())

	if numEntries == 0 || offset >= numEntries {
		return []*model.FeaturedCarouselEntry{}, 0, nil
	}

	sort.Slice(allEntries, func(i, j int) bool {
		return strings.Compare(allEntries[i].ID, allEntries[j].ID) <= 0
	})
	upper := offset + limit
	if upper > numEntries {
		upper = numEntries
	}

	carousels := allEntries[offset:upper]

	return carousels, int32(len(s.featuredCarouselEntries)), nil
}
