package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) GetFeaturedCarouselEntry(req *discovery.GetFeaturedCarouselEntryRequest) (*model.FeaturedCarouselEntry, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	entry, ok := s.featuredCarouselEntries[req.GetID()]
	if !ok {
		return nil, data.ErrNotFound
	}

	return entry, nil
}
