package memory

import (
	"sort"
	"strings"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) GetFeaturedCarousels(req *discovery.GetFeaturedCarouselsRequest) ([]*model.FeaturedCarousel, int32, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	allCarousels := []*model.FeaturedCarousel{}
	for _, val := range s.featuredCarousels {
		allCarousels = append(allCarousels, val)
	}

	numCarousels := len(allCarousels)
	offset := int(req.GetOffset())
	limit := int(req.GetLimit())

	if numCarousels == 0 || offset >= numCarousels {
		return []*model.FeaturedCarousel{}, 0, nil
	}

	sort.Slice(allCarousels, func(i, j int) bool {
		return strings.Compare(allCarousels[i].ID, allCarousels[j].ID) <= 0
	})
	upper := offset + limit
	if upper > numCarousels {
		upper = numCarousels
	}

	carousels := allCarousels[offset:upper]

	return carousels, int32(len(s.featuredCarousels)), nil
}
