package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) GetFeaturedSchedule(req *discovery.GetFeaturedScheduleRequest) (*model.FeaturedCarouselSchedule, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	schedule, ok := s.featuredCarouselSchedules[req.GetScheduleID()]
	if !ok {
		schedule, ok = s.featuredCarouselSchedulesBySlug[req.GetScheduleID()]
		if !ok {
			return nil, data.ErrNotFound
		}
	}

	return schedule, nil
}
