package memory

import (
	"sort"
	"strings"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) GetFeaturedSchedules(req *discovery.GetFeaturedSchedulesRequest) ([]*model.FeaturedCarouselSchedule, int32, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	allSchedules := []*model.FeaturedCarouselSchedule{}
	for _, val := range s.featuredCarouselSchedules {
		allSchedules = append(allSchedules, val)
	}

	numSchedules := len(allSchedules)
	offset := int(req.GetOffset())
	limit := int(req.GetLimit())

	if numSchedules == 0 || offset >= numSchedules {
		return []*model.FeaturedCarouselSchedule{}, 0, nil
	}

	sort.Slice(allSchedules, func(i, j int) bool {
		return strings.Compare(allSchedules[i].Description, allSchedules[j].Description) <= 0
	})
	upper := offset + limit
	if upper > numSchedules {
		upper = numSchedules
	}

	schedules := allSchedules[offset:upper]

	return schedules, int32(len(s.featuredCarouselSchedules)), nil
}
