package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
)

func (s *store) HardDeleteDiscoveryData(req *discovery.HardDeleteExtensionDiscoveryDataRequest) error {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	_, ok := s.extensionsDiscoveryData[req.GetExtensionID()]
	if !ok {
		return data.ErrNotFound
	}

	delete(s.extensionsDiscoveryData, req.GetExtensionID())
	return nil
}
