package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) OrderCategories(req *discovery.OrderCategoriesRequest) ([]*model.Category, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	ret := make([]*model.Category, len(req.GetCategories()))
	for i, cid := range req.GetCategories() {
		cat, ok := s.categories[cid]
		if ok {
			cat.Order = float32(i)
			ret[i] = cat
		} else {
			ret[i] = nil
		}
	}
	return ret, nil
}
