package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) OrderCategory(req *discovery.OrderCategoryRequest) (*model.Category, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	cat, ok := s.categories[req.GetCategoryID()]
	if !ok {
		return nil, data.ErrCategoryNotFound
	}

	orderMap := make(map[string]int)

	for i, extension := range req.GetExtensions() {
		orderMap[extension] = i
	}

	entries, ok := s.categoriesToExtensions[req.GetCategoryID()]
	if ok {
		for _, entry := range entries {
			order, oOk := orderMap[entry.ExtensionID]
			if oOk {
				entry.Order = float32(order)
			}
		}
	}

	return cat, nil
}
