package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) OrderFeaturedCarousel(req *discovery.OrderFeaturedCarouselRequest) (*model.FeaturedCarousel, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	carousel, ok := s.featuredCarousels[req.GetCarouselID()]
	if !ok {
		return nil, data.ErrNotFound
	}

	orderMap := make(map[string]int)

	for i, entryID := range req.GetEntryIDs() {
		orderMap[entryID] = i
	}

	entries, ok := s.carouselsToEntries[req.GetCarouselID()]
	if ok {
		for _, entry := range entries {
			order, oOk := orderMap[entry.ID]
			if oOk {
				entry.Order = float32(order)
			}
		}
	}

	return carousel, nil
}
