package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) RemoveExtensionFromCategory(req *discovery.RemoveExtensionFromCategoryRequest) (*model.CuratedCategoryExtension, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	cat, ok := s.categories[req.GetCategoryID()]
	if !ok {
		return nil, data.ErrCategoryNotFound
	}

	// This code is in EMS
	if cat.Type == model.CategoryTypeDeveloper {
		return nil, data.ErrNotImplemented
	}

	extensionEntries := s.extensionsToCategories[req.GetExtensionID()]
	if !ok {
		return nil, data.ErrExtensionNotInCategory
	}
	var found *model.CuratedCategoryExtension

	for i, entry := range extensionEntries {
		if entry.CategoryID == req.GetCategoryID() {
			found = entry
			extensionEntries[i] = extensionEntries[len(extensionEntries)-1]
			extensionEntries = extensionEntries[:len(extensionEntries)-1]
			s.extensionsToCategories[req.GetExtensionID()] = extensionEntries
		}
	}
	if found == nil {
		return nil, data.ErrExtensionNotInCategory
	}

	categoryEntries := s.categoriesToExtensions[req.GetCategoryID()]
	if !ok {
		return nil, data.ErrExtensionNotInCategory
	}

	catFound := false
	for i, entry := range categoryEntries {
		if entry.ExtensionID == req.GetExtensionID() {
			catFound = true
			categoryEntries[i] = categoryEntries[len(categoryEntries)-1]
			categoryEntries = categoryEntries[:len(categoryEntries)-1]
			s.extensionsToCategories[req.GetExtensionID()] = categoryEntries
		}
	}
	if !catFound {
		// this should never happen
		return nil, data.ErrExtensionNotInCategory
	}

	return found, nil
}
