package memory

import (
	"time"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
)

func (s *store) SoftDeleteDiscoveryVersionData(req *discovery.DeleteExtensionVersionDiscoveryDataRequest) error {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	versions, ok := s.extensionsDiscoveryData[req.GetExtensionID()]
	if !ok {
		return data.ErrNotFound
	}

	discoData, ok := versions[req.GetVersion()]
	if !ok {
		return data.ErrNotFound
	}

	discoData.DeletedAt = time.Now()
	versions[req.GetVersion()] = discoData
	s.extensionsDiscoveryData[req.GetExtensionID()] = versions

	return nil
}
