package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) UpdateCategory(req *discovery.UpdateCategoryRequest) (*model.Category, error) {
	category := req.GetCategory()

	err := data.ValidateCategoryUpsert(category, true)
	if err != nil {
		return nil, err
	}

	defer s.mutex.Unlock()
	s.mutex.Lock()

	cat, ok := s.categories[req.GetCategoryID()]
	if !ok {
		return nil, data.ErrCategoryNotFound
	}

	err = data.ValidateCategoryUpdate(cat, category)
	if err != nil {
		return nil, err
	}

	if category.GetType() != nil {
		cat.Type = category.GetType().GetValue()
	}
	if category.GetSortKey() != nil {
		cat.SortKey = category.GetSortKey().GetValue()
	}
	if category.GetReadonly() != nil {
		cat.Readonly = category.GetReadonly().GetValue()
	}
	if category.GetOrder() != nil {
		cat.Order = category.GetOrder().GetValue()
	}
	if category.GetVisible() != nil {
		cat.Visible = category.GetVisible().GetValue()
	}

	s.categories[req.GetCategoryID()] = cat

	return cat, nil
}
