package memory

import (
	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) UpdateDiscoveryData(req *discovery.UpdateExtensionVersionDiscoveryDataRequest) (*model.ExtensionDiscoveryData, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	reqData := req.GetUpdateData()
	extensionID := reqData.GetExtensionID()
	versionID := reqData.GetVersion()
	extensionVersions, ok := s.extensionsDiscoveryData[extensionID]

	if !ok {
		return nil, data.ErrNotFound
	}
	discoveryData, ok := extensionVersions[versionID]
	if !ok {
		return nil, data.ErrNotFound
	}

	updateCategory := false
	var oldCategories []string

	if reqData.GetName() != nil {
		discoveryData.Name = reqData.GetName().GetValue()
	}
	if reqData.GetAuthorName() != nil {
		discoveryData.AuthorName = reqData.GetAuthorName().GetValue()
	}
	if reqData.GetCategories() != nil {
		oldCategories = discoveryData.Categories
		discoveryData.Categories = reqData.GetCategories().GetValues()
		updateCategory = true
	}
	if reqData.GetDescription() != nil {
		discoveryData.Description = reqData.GetDescription().GetValue()
	}
	if reqData.GetEULATOSURL() != nil {
		discoveryData.EULATOSURL = reqData.GetEULATOSURL().GetValue()
	}
	if reqData.GetGames() != nil {
		discoveryData.Games = reqData.GetGames().GetValues()
	}
	if reqData.GetIconPaths() != nil {
		discoveryData.IconPaths = model.MapToHstore(reqData.GetIconPaths().GetValues())
	}
	if reqData.GetIconURLs() != nil {
		discoveryData.IconURLs = model.MapToHstore(reqData.GetIconURLs().GetValues())
	}
	if reqData.GetPrivacyPolicyURL() != nil {
		discoveryData.PrivacyPolicyURL = reqData.GetPrivacyPolicyURL().GetValue()
	}
	if reqData.GetScreenshotPaths() != nil {
		discoveryData.ScreenshotPaths = reqData.GetScreenshotPaths().GetValues()
	}
	if reqData.GetScreenshotURLs() != nil {
		discoveryData.ScreenshotURLs = reqData.GetScreenshotURLs().GetValues()
	}
	if reqData.GetSummary() != nil {
		discoveryData.Summary = reqData.GetSummary().GetValue()
	}
	if reqData.GetSupportEmail() != nil {
		discoveryData.SupportEmail = reqData.GetSupportEmail().GetValue()
	}
	if reqData.GetViewerSummary() != nil {
		discoveryData.ViewerSummary = reqData.GetViewerSummary().GetValue()
	}

	extensionVersions[versionID] = discoveryData
	s.extensionsDiscoveryData[extensionID] = extensionVersions

	entry := model.ExtensionDiscoveryData{
		Timestamps: model.Timestamps{
			CreatedAt: discoveryData.CreatedAt,
			UpdatedAt: discoveryData.UpdatedAt,
		},
		ExtensionID:      discoveryData.ExtensionID,
		Version:          discoveryData.Version,
		AuthorName:       discoveryData.AuthorName,
		Categories:       discoveryData.Categories,
		Description:      discoveryData.Description,
		EULATOSURL:       discoveryData.EULATOSURL,
		Games:            discoveryData.Games,
		IconPaths:        discoveryData.IconPaths,
		IconURLs:         discoveryData.IconURLs,
		Name:             discoveryData.Name,
		PrivacyPolicyURL: discoveryData.PrivacyPolicyURL,
		ScreenshotPaths:  discoveryData.ScreenshotPaths,
		ScreenshotURLs:   discoveryData.ScreenshotURLs,
		Summary:          discoveryData.Summary,
		SupportEmail:     discoveryData.SupportEmail,
		ViewerSummary:    discoveryData.ViewerSummary,
	}

	if updateCategory {
		for _, catID := range oldCategories {
			categoryEntries := s.categoriesToExtensions[catID]
			if !ok {
				return nil, data.ErrExtensionNotInCategory
			}

			for i, catEnt := range categoryEntries {
				if catEnt.ExtensionID == entry.ExtensionID {
					categoryEntries[i] = categoryEntries[len(categoryEntries)-1]
					categoryEntries = categoryEntries[:len(categoryEntries)-1]
					s.extensionsToCategories[entry.ExtensionID] = categoryEntries
				}
			}
		}

		for _, catID := range reqData.GetCategories().GetValues() {
			curatedEntry := model.CuratedCategoryExtension{
				CategoryID:  catID,
				ExtensionID: entry.ExtensionID,
			}
			extensions, ok := s.categoriesToExtensions[catID]
			if !ok {
				extensions = []*model.CuratedCategoryExtension{}
			}
			extensions = append(extensions, &curatedEntry)
			s.categoriesToExtensions[catID] = extensions
		}
	}

	return &entry, nil
}
