package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
	"code.justin.tv/extensions/discovery/twirputils"
)

func (s *store) UpdateFeaturedCarousel(req *discovery.UpdateFeaturedCarouselRequest) (*model.FeaturedCarousel, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	carousel, ok := s.featuredCarousels[req.GetCarouselID()]
	if !ok {
		return nil, data.ErrNotFound
	}

	startTime, err := twirputils.UnwrapTimestampPointer(req.GetFeaturedCarousel().GetStartTime())
	if err != nil {
		return nil, data.ErrMissingParameter
	}

	carousel.ScheduleID = req.GetFeaturedCarousel().GetScheduleID()
	carousel.StartTime = *startTime

	s.featuredCarousels[req.GetCarouselID()] = carousel
	s.scheduleIDsToCarousels[carousel.ScheduleID] = carousel

	return carousel, nil
}
