package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) UpdateFeaturedCarouselEntry(req *discovery.UpdateFeaturedCarouselEntryRequest) (*model.FeaturedCarouselEntry, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	entry, ok := s.featuredCarouselEntries[req.GetID()]
	if !ok {
		return nil, data.ErrNotFound
	}

	if req.GetFeaturedCarouselEntry().GetCarouselID() != nil {
		entry.CarouselID = req.GetFeaturedCarouselEntry().GetCarouselID().GetValue()
	}

	if req.GetFeaturedCarouselEntry().GetContent() != nil {
		entry.ClickThrough = req.GetFeaturedCarouselEntry().GetContent().GetClickThrough()
		entry.ImageURL = req.GetFeaturedCarouselEntry().GetContent().GetImageURL()
		entry.Title = req.GetFeaturedCarouselEntry().GetContent().GetTitle()
	}

	if req.GetFeaturedCarouselEntry().GetOrder() != nil {
		entry.Order = req.GetFeaturedCarouselEntry().GetOrder().GetValue()
	}

	s.featuredCarouselEntries[req.GetID()] = entry

	return entry, nil
}
