package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) UpdateFeaturedSchedule(req *discovery.UpdateFeaturedScheduleRequest) (*model.FeaturedCarouselSchedule, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	schedule, ok := s.featuredCarouselSchedules[req.GetScheduleID()]
	if !ok {
		return nil, data.ErrNotFound
	}

	schedule.Description = req.GetFeaturedSchedule().GetDescription()

	s.featuredCarouselSchedules[req.GetScheduleID()] = schedule

	return schedule, nil
}
