package postgres

import (
	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
	"code.justin.tv/extensions/discovery/twirputils"

	"github.com/pkg/errors"
)

func (s *store) AddExtensionToCategory(req *discovery.AddExtensionToCategoryRequest) (*model.CuratedCategoryExtension, error) {
	var numExtensions int
	var order float32

	if req.GetOrder() != nil {
		order = req.GetOrder().GetValue()
	} else {
		if err := s.db.Model(&model.CuratedCategoryExtension{}).Where(&model.CuratedCategoryExtension{CategoryID: req.GetCategoryID()}).Count(&numExtensions).Error; err != nil {
			return nil, errors.Wrapf(err, "error counting the number of extensions in category %s", req.GetCategoryID())
		}

		order = float32(numExtensions)
	}

	startTime, err := twirputils.UnwrapTimestampPointer(req.GetStartTime())
	if err != nil {
		return nil, data.ErrMissingParameter
	}

	curatedEntry := model.CuratedCategoryExtension{
		CategoryID:  req.GetCategoryID(),
		ExtensionID: req.GetExtensionID(),
		StartTime:   startTime,
		Order:       order,
	}

	if err := s.db.Create(&curatedEntry).Error; err != nil {
		return nil, errors.Wrapf(err, "error creating a curated category extension for category %s and extension %s",
			req.GetCategoryID(), req.GetExtensionID())
	}

	return &curatedEntry, nil
}
