package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
	"code.justin.tv/extensions/discovery/twirputils"

	"github.com/lib/pq"
	"github.com/pkg/errors"
)

func (s *store) CreateCategory(req *discovery.AddCategoryRequest) (*model.Category, error) {
	category := req.GetCategory()

	readonly := category.GetReadonly() != nil && category.GetReadonly().GetValue()
	var order float32
	if category.GetOrder() != nil {
		order = category.GetOrder().GetValue()
	} else {
		var numCategories int

		if err := s.db.Model(&model.Category{}).Count(&numCategories).Error; err != nil {
			return nil, errors.Wrap(err, "error counting categories")
		}

		order = float32(numCategories)
	}

	cat := model.Category{
		Deleted:  false,
		Order:    order,
		Readonly: readonly,
		Slug:     twirputils.UnwrapStringValuePointer(category.GetSlug()),
		SortKey:  category.GetSortKey().GetValue(),
		Type:     category.GetType().GetValue(),
		Visible:  false,
	}

	if err := s.db.Create(&cat).Error; err != nil {
		if pqErr, ok := err.(*pq.Error); ok {
			if pqErr.Code.Name() == "unique_violation" {
				return nil, data.ErrSlugTaken
			}
		}

		return nil, errors.Wrapf(err, "error creating category %+v", cat)
	}
	return &cat, nil
}
