package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
	"code.justin.tv/extensions/discovery/twirputils"

	"github.com/pkg/errors"
)

func (s *store) CreateFeaturedCarousel(req *discovery.AddFeaturedCarouselRequest) (*model.FeaturedCarousel, error) {
	startTime, err := twirputils.UnwrapTimestampPointer(req.GetFeaturedCarousel().GetStartTime())
	if err != nil {
		return nil, data.ErrMissingParameter
	}

	carousel := model.FeaturedCarousel{
		ScheduleID: req.GetFeaturedCarousel().GetScheduleID(),
		StartTime:  *startTime,
	}

	if err := s.db.Create(&carousel).Error; err != nil {
		return nil, errors.Wrapf(err, "error creating carousel for schedule %s at time %d",
			req.GetFeaturedCarousel().GetScheduleID(), startTime.Unix())
	}
	return &carousel, nil
}
