package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/pkg/errors"
)

func (s *store) CreateFeaturedCarouselEntry(req *discovery.AddFeaturedCarouselEntryRequest) (*model.FeaturedCarouselEntry, error) {
	cid := req.GetFeaturedCarouselEntry().GetCarouselID().GetValue()
	content := req.GetFeaturedCarouselEntry().GetContent()

	var order float32
	if req.GetFeaturedCarouselEntry().GetOrder() != nil {
		order = req.GetFeaturedCarouselEntry().GetOrder().GetValue()
	} else {
		var numEntries int

		if err := s.db.Model(&model.FeaturedCarouselEntry{}).
			Where(&model.FeaturedCarouselEntry{CarouselID: cid}).
			Count(&numEntries).Error; err != nil {
			return nil, errors.Wrapf(err, "error counting the number of entries in carousel %s", cid)
		}

		order = float32(numEntries)
	}

	entry := model.FeaturedCarouselEntry{
		CarouselID:   cid,
		ClickThrough: content.ClickThrough,
		ImageURL:     content.ImageURL,
		Title:        content.Title,
		Order:        order,
	}

	if err := s.db.Create(&entry).Error; err != nil {
		return nil, errors.Wrapf(err, "error creating featured carousel entry %+v", entry)
	}

	return &entry, nil
}
