package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
	"code.justin.tv/extensions/discovery/twirputils"

	"github.com/lib/pq"
	"github.com/pkg/errors"
)

func (s *store) CreateFeaturedSchedule(req *discovery.AddFeaturedScheduleRequest) (*model.FeaturedCarouselSchedule, error) {
	schedule := model.FeaturedCarouselSchedule{
		Description: req.GetFeaturedSchedule().GetDescription(),
		Slug:        twirputils.UnwrapStringValuePointer(req.GetFeaturedSchedule().GetSlug()),
	}

	if err := s.db.Create(&schedule).Error; err != nil {
		if pqErr, ok := err.(*pq.Error); ok {
			if pqErr.Code.Name() == "unique_violation" {
				return nil, data.ErrSlugTaken
			}
		}

		return nil, errors.Wrap(err, "error creating featured carousel schedule")
	}
	return &schedule, nil
}
