package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/pkg/errors"
)

func (s *store) DeleteCategory(req *discovery.DeleteCategoryRequest) error {
	cat := model.Category{ID: req.GetCategoryID()}

	if req.GetSoftDelete() {
		if err := s.db.Model(&cat).Updates(model.Category{Deleted: true}).Error; err != nil {
			return errors.Wrapf(err, "error soft-deleting category %s", req.GetCategoryID())
		}
	} else {
		if err := s.db.Delete(&model.Category{ID: req.GetCategoryID()}).Error; err != nil {
			return errors.Wrapf(err, "error hard deleting category %s", req.GetCategoryID())
		}
	}

	return nil
}
