package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/jinzhu/gorm"
	"github.com/pkg/errors"
)

func (s *store) DeleteFeaturedCarousel(req *discovery.DeleteFeaturedCarouselRequest) (*model.FeaturedCarousel, error) {
	var carousel model.FeaturedCarousel
	err := s.db.Where(&model.FeaturedCarousel{
		ID: req.GetCarouselID(),
	}).Find(&carousel).Error

	if err != nil {
		if gorm.IsRecordNotFoundError(err) {
			return nil, data.ErrNotFound
		}
		return nil, errors.Wrapf(err, "error fetching carousel %s", req.GetCarouselID())
	}

	if err := s.db.Delete(&model.FeaturedCarousel{ID: req.GetCarouselID()}).Error; err != nil {
		return nil, errors.Wrapf(err, "error deleting carousel %s", req.GetCarouselID())
	}

	return &carousel, nil
}
