package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/jinzhu/gorm"
	"github.com/pkg/errors"
)

func (s *store) DeleteFeaturedCarouselEntry(req *discovery.DeleteFeaturedCarouselEntryRequest) (*model.FeaturedCarouselEntry, error) {
	var entry model.FeaturedCarouselEntry
	err := s.db.Where(&model.FeaturedCarouselEntry{
		ID: req.GetID(),
	}).Find(&entry).Error
	if err != nil {
		if gorm.IsRecordNotFoundError(err) {
			return nil, data.ErrNotFound
		}
		return nil, errors.Wrapf(err, "error fetching the carousel entry %s", req.GetID())
	}

	if err := s.db.Delete(&model.FeaturedCarouselEntry{ID: req.GetID()}).Error; err != nil {
		return nil, errors.Wrapf(err, "error deleting carousel entry %s", req.GetID())
	}

	return &entry, nil
}
