package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
	"github.com/pkg/errors"

	"github.com/jinzhu/gorm"
)

func (s *store) DeleteFeaturedSchedule(req *discovery.DeleteFeaturedScheduleRequest) (*model.FeaturedCarouselSchedule, error) {
	var schedule model.FeaturedCarouselSchedule
	err := s.db.Where(&model.FeaturedCarouselSchedule{
		ID: req.GetScheduleID(),
	}).Find(&schedule).Error
	if err != nil {
		if gorm.IsRecordNotFoundError(err) {
			return nil, data.ErrNotFound
		}
		return nil, errors.Wrapf(err, "error getting featured carousel schedule %s", req.GetScheduleID())
	}

	if err := s.db.Delete(&model.FeaturedCarouselSchedule{ID: req.GetScheduleID()}).Error; err != nil {
		return nil, errors.Wrapf(err, "error deleting featured carousel schedule %s", req.GetScheduleID())
	}

	return &schedule, nil
}
