package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
	"github.com/pkg/errors"
)

func (s *store) EditCategoryTranslation(req *discovery.EditCategoryTranslationRequest) (*model.CategoryTranslation, *model.Category, error) {
	var cat model.Category

	if err := s.db.Where(model.Category{ID: req.GetCategoryID()}).First(&cat).Error; err != nil {
		return nil, nil, data.ErrCategoryNotFound
	}

	var translation model.CategoryTranslation
	err := s.db.Where(model.CategoryTranslation{
		CategoryID:     req.GetCategoryID(),
		LanguageCodeID: s.getLanguageCodeID(req.GetLanguage()),
	}).Assign(model.CategoryTranslation{
		Name:        req.GetName(),
		Description: req.GetDescription(),
	}).FirstOrCreate(&translation).Error
	if err != nil {
		return nil, nil, errors.Wrapf(err, "error updating category translation %+v", *req)
	}

	return &translation, &cat, nil
}
