package postgres

import (
	"fmt"

	"code.justin.tv/extensions/discovery/data/model"
	"code.justin.tv/extensions/discovery/golibs/logger"

	"github.com/pkg/errors"
)

func (s *store) GetCarouselEntriesByCarouselIDs(ids []string) ([][]*model.FeaturedCarouselEntry, error) {

	var entries []*model.FeaturedCarouselEntry
	err := s.db.Where("carousel_id in (?)", ids).Find(&entries).Error
	if err != nil {
		return nil, errors.Wrapf(err, "error getting carousel entries for carousels %v", ids)
	}

	// Have to map entries to appropriate categoryID
	idsToIndex := map[string]int{}
	for i, id := range ids {
		idsToIndex[id] = i
	}

	var haveLogged bool
	entriesResponse := make([][]*model.FeaturedCarouselEntry, len(ids))
	for _, entry := range entries {
		index, ok := idsToIndex[entry.CarouselID]
		if !ok {
			if !haveLogged {
				// use a bool flag to prevent spamming logs with potentially many messages
				dimensions := map[string]interface{}{
					"ids": ids,
				}
				s.logger.Error(fmt.Sprintf("got unexpected row: %+v", entry), dimensions,
					logger.GetStackChain(errors.New("unexpected row")))
				haveLogged = true
			}
			continue
		}
		list := entriesResponse[index]
		list = append(list, entry)
		entriesResponse[index] = list
	}

	return entriesResponse, nil
}
