package postgres

import (
	"code.justin.tv/extensions/discovery/data/model"
	"github.com/pkg/errors"
)

func (s *store) GetCarouselsByScheduleIDs(scheduleIDs []string) ([]*model.FeaturedCarousel, error) {
	var carousels []*model.FeaturedCarousel

	err := s.db.Where("schedule_id in (?)", scheduleIDs).Find(&carousels).Error
	if err != nil {
		return nil, errors.Wrapf(err, "Error finding carousels for schedule ids %v", scheduleIDs)
	}

	return carousels, nil
}
