package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data/model"
	"github.com/pkg/errors"
)

func (s *store) GetCategories(req *discovery.GetCategoriesRequest) ([]*model.Category, []*model.CategoryTranslation, int32, error) {
	var categories []*model.Category

	db := s.db.Model(&model.Category{})
	if req.GetType() != "" {
		db = db.Where(&model.Category{Type: req.GetType()})
	}
	if !req.GetIncludeHidden() {
		db = db.Where(`visible = TRUE`)
	}
	if !req.GetIncludeDeleted() {
		db = db.Where("deleted = FALSE")
	}
	if err := db.Limit(req.GetLimit()).Offset(req.GetOffset()).Order(`"order" ASC`).Find(&categories).Error; err != nil {
		return nil, nil, 0, errors.Wrapf(err, "error getting categories of type %s", req.GetType())
	}

	numEntries := 0
	if err := db.Count(&numEntries).Error; err != nil {
		return nil, nil, 0, errors.Wrapf(err, "error counting categories of type %s", req.GetType())
	}

	translations := make([]*model.CategoryTranslation, 0, len(categories))
	for _, cat := range categories {
		// TODO: implement this for postgres as a join above?

		translation, err := s.getTranslation(req.GetLanguage(), cat.ID)
		if err != nil {
			return nil, nil, 0, errors.Wrapf(err, "error getting translation for category %s in language %s", cat.ID, req.GetLanguage())
		}
		translations = append(translations, translation)
	}

	return categories, translations, int32(numEntries), nil
}
