package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/jinzhu/gorm"
	"github.com/pkg/errors"
)

func (s *store) GetCategory(req *discovery.GetCategoryRequest) (*model.Category, *model.CategoryTranslation, error) {
	// This value used both as-is and as a pointer so have to pull it out
	categoryID := req.GetCategoryID()

	var cat model.Category
	err := s.db.
		Where(&model.Category{
			ID: categoryID,
		}).
		Or(&model.Category{
			Slug: &categoryID,
		}).
		Find(&cat).Error
	if err != nil {
		if gorm.IsRecordNotFoundError(err) {
			return nil, nil, data.ErrNotFound
		}
		return nil, nil, errors.Wrapf(err, "error getting category %s", req.GetCategoryID())
	}

	translation, err := s.getTranslation(req.GetLanguage(), cat.ID)
	if err != nil {
		return nil, nil, errors.Wrapf(err, "error getting the translation for category %s into language %s", cat.ID, req.GetLanguage())
	}

	return &cat, translation, nil
}
