package postgres

import (
	"time"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/jinzhu/gorm"
	"github.com/pkg/errors"
)

func (s *store) GetCurrentCarousel(req *discovery.GetFeaturedScheduleRequest) (*model.FeaturedCarousel, error) {
	var schedule model.FeaturedCarouselSchedule
	err := s.db.Where(&model.FeaturedCarouselSchedule{
		ID: req.GetScheduleID(),
	}).Find(&schedule).Error
	if err != nil {
		if gorm.IsRecordNotFoundError(err) {
			return nil, data.ErrNotFound
		}
		return nil, errors.Wrapf(err, "error schedule %s", req.GetScheduleID())
	}

	var carousel model.FeaturedCarousel

	now := time.Now()
	err = s.db.Where("schedule_id = ? AND start_time < ?", req.GetScheduleID(), now).
		Order("start_time DESC").
		First(&carousel).Error
	if err != nil {
		if gorm.IsRecordNotFoundError(err) {
			return nil, nil
		}
		return nil, errors.Wrapf(err, "error getting current carousel for schedule %s", req.GetScheduleID())
	}

	return &carousel, nil
}
