package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/jinzhu/gorm"
	"github.com/pkg/errors"
)

func (s *store) GetEntriesForCarousel(req *discovery.GetFeaturedCarouselRequest) ([]*model.FeaturedCarouselEntry, error) {
	var entries []*model.FeaturedCarouselEntry
	q := s.db.Model(&model.FeaturedCarouselEntry{}).Where(&model.FeaturedCarouselEntry{CarouselID: req.GetCarouselID()})
	q = q.Order(`"order" ASC`)

	if err := q.Find(&entries).Error; err != nil {
		if gorm.IsRecordNotFoundError(err) {
			return nil, data.ErrNotFound
		}
		return nil, errors.Wrapf(err, "error getting entries for carousel %s", req.GetCarouselID())
	}

	return entries, nil
}
