package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/jinzhu/gorm"
	"github.com/pkg/errors"
)

func (s *store) GetDiscoveryData(req *discovery.GetExtensionVersionDiscoveryDataRequest) (*model.ExtensionDiscoveryData, error) {
	var discoData model.ExtensionDiscoveryData
	err := s.db.
		Where(&model.ExtensionDiscoveryData{
			ExtensionID: req.GetExtensionID(),
			Version:     req.GetVersion(),
		}).
		Find(&discoData).Error
	if err != nil {
		if gorm.IsRecordNotFoundError(err) {
			return nil, data.ErrNotFound
		}
		return nil, errors.Wrapf(err, "error getting discovery data %s-%s", req.GetExtensionID(), req.GetVersion())
	}

	return &discoData, nil
}
