package postgres

import (
	"time"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/jinzhu/gorm"
	"github.com/pkg/errors"
)

func (s *store) GetExtensionsForCategory(req *discovery.GetCategoryExtensionsRequest) ([]*model.CuratedCategoryExtension, int32, error) {
	var totalCount int32

	q := s.db.
		Model(&model.CuratedCategoryExtension{}).
		Where(&model.CuratedCategoryExtension{CategoryID: req.GetCategoryID()})

	if req.GetSortKey() == model.CategorySortkeyTime {
		q = q.
			Where("start_time < ?", time.Now()).
			Order("start_time DESC")
	} else {
		q = q.Order(`"order" ASC`)
	}

	err := q.Count(&totalCount).Error
	if err != nil {
		return nil, 0, errors.Wrapf(err, "error counting extensions for category %s", req.GetCategoryID())
	}

	var relations []*model.CuratedCategoryExtension
	if err := q.
		Limit(req.GetLimit()).
		Offset(req.GetOffset()).
		Find(&relations).Error; err != nil {
		if gorm.IsRecordNotFoundError(err) {
			return nil, 0, data.ErrNotFound
		}
		return nil, 0, errors.Wrapf(err, "error getting extensions for category %s", req.GetCategoryID())
	}

	return relations, totalCount, nil
}
