package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/pkg/errors"
)

func (s *store) GetFeaturedCarouselEntries(req *discovery.GetFeaturedCarouselEntriesRequest) ([]*model.FeaturedCarouselEntry, int32, error) {
	var entries []*model.FeaturedCarouselEntry

	numEntries := 0

	db := s.db.Model(&model.FeaturedCarouselEntry{})

	if err := db.Count(&numEntries).Error; err != nil {
		return nil, 0, errors.Wrap(err, "error counting the featured carousel entries")
	}
	if err := db.Limit(req.GetLimit()).Offset(req.GetLimit()).Order(`"id" ASC`).Find(&entries).Error; err != nil {
		return nil, 0, errors.Wrap(err, "error fetching featured carousel entries")
	}

	return entries, int32(numEntries), nil
}
