package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
	"github.com/pkg/errors"

	"github.com/jinzhu/gorm"
)

func (s *store) GetFeaturedCarouselEntry(req *discovery.GetFeaturedCarouselEntryRequest) (*model.FeaturedCarouselEntry, error) {
	var entry model.FeaturedCarouselEntry
	err := s.db.Where(&model.FeaturedCarouselEntry{
		ID: req.GetID(),
	}).Find(&entry).Error
	if err != nil {
		if gorm.IsRecordNotFoundError(err) {
			return nil, data.ErrNotFound
		}
		return nil, errors.Wrapf(err, "error getting carousel entry %s", req.GetID())
	}

	return &entry, nil
}
