package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/pkg/errors"
)

func (s *store) GetFeaturedCarousels(req *discovery.GetFeaturedCarouselsRequest) ([]*model.FeaturedCarousel, int32, error) {
	var carousels []*model.FeaturedCarousel

	numCarousels := 0

	db := s.db.Model(&model.FeaturedCarousel{})

	if err := db.Count(&numCarousels).Error; err != nil {
		return nil, 0, errors.Wrap(err, "error counting carousels")
	}
	if err := db.Limit(req.GetLimit()).Offset(req.GetOffset()).Order(`"id" ASC`).Find(&carousels).Error; err != nil {
		return nil, 0, errors.Wrap(err, "error getting carousels")
	}

	return carousels, int32(numCarousels), nil
}
