package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/jinzhu/gorm"
	"github.com/pkg/errors"
)

func (s *store) GetFeaturedSchedule(req *discovery.GetFeaturedScheduleRequest) (*model.FeaturedCarouselSchedule, error) {
	scheduleID := req.GetScheduleID()
	var schedule model.FeaturedCarouselSchedule
	err := s.db.Where(&model.FeaturedCarouselSchedule{
		ID: scheduleID,
	}).Or(&model.FeaturedCarouselSchedule{
		Slug: &scheduleID,
	}).Find(&schedule).Error
	if err != nil {
		if gorm.IsRecordNotFoundError(err) {
			return nil, data.ErrNotFound
		}
		return nil, errors.Wrapf(err, "error getting featured carousel schedule %s", scheduleID)
	}

	return &schedule, nil
}
