package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/pkg/errors"
)

func (s *store) GetFeaturedSchedules(req *discovery.GetFeaturedSchedulesRequest) ([]*model.FeaturedCarouselSchedule, int32, error) {
	var schedules []*model.FeaturedCarouselSchedule

	numSchedules := 0

	db := s.db.Model(&model.FeaturedCarouselSchedule{})

	if err := db.Count(&numSchedules).Error; err != nil {
		return nil, 0, errors.Wrap(err, "error getting the number of schedules")
	}
	if err := db.Limit(req.GetLimit()).Offset(req.GetOffset()).Order(`"description" ASC`).Find(&schedules).Error; err != nil {
		return nil, 0, errors.Wrap(err, "error getting schedules")
	}

	return schedules, int32(numSchedules), nil
}
