package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/jinzhu/gorm"
)

func (s *store) HardDeleteDiscoveryData(req *discovery.HardDeleteExtensionDiscoveryDataRequest) error {
	if err := s.db.Unscoped().Where("extension_id = ?", req.GetExtensionID()).Delete(&model.ExtensionDiscoveryData{}).Error; err != nil {
		if gorm.IsRecordNotFoundError(err) {
			return data.ErrNotFound
		}
		// Assumes that all errors here are because the DB was unavailable
		return data.ErrUnavailable
	}

	return nil
}
