package postgres

import (
	"fmt"
	"strings"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/pkg/errors"
)

func (s *store) OrderCategories(req *discovery.OrderCategoriesRequest) ([]*model.Category, error) {
	scope := s.db.NewScope(&model.Category{})
	tableName := scope.GetModelStruct().TableName(s.db)

	// Table name presumed to be escaped since it's from gorm
	sql := fmt.Sprintf(`
		update %s as t set "order" = c.o from
		   (values ?)
		as c(id, o)
		where c.id = t.id;
	`, tableName)

	var valueStrings []string
	for i, cid := range req.GetCategories() {
		valueString := fmt.Sprintf("('%s', %d)", cid, i)
		valueStrings = append(valueStrings, valueString)
	}
	values := strings.Join(valueStrings, ",")

	if err := s.db.Exec(sql, values).Error; err != nil {
		return nil, errors.Wrapf(err, "error executing sql `%s` with values '%v'", sql, values)
	}

	var categories []*model.Category
	if err := s.db.Where(req.GetCategories()).Order(`"order" ASC`).Find(&categories).Error; err != nil {
		return nil, errors.Wrap(err, "error getting categories")
	}
	return categories, nil
}
