package postgres

import (
	"fmt"
	"strings"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/jinzhu/gorm"
	"github.com/pkg/errors"
)

func (s *store) OrderCategory(req *discovery.OrderCategoryRequest) (*model.Category, error) {
	var cat model.Category

	if err := s.db.Where(model.Category{ID: req.GetCategoryID()}).First(&cat).Error; err != nil {
		if gorm.IsRecordNotFoundError(err) {
			return nil, data.ErrCategoryNotFound
		}
		return nil, errors.Wrapf(err, "error fetching category %s", req.GetCategoryID())
	}

	scope := s.db.NewScope(&model.CuratedCategoryExtension{})
	tableName := scope.GetModelStruct().TableName(s.db)

	// Table name presumed to be escaped since it's from gorm
	sql := fmt.Sprintf(`
		update %s as t set "order" = c.o from
		   (values ?)
		as c(id, o)
		where c.id = t.extension_id and t.category_id = ?;
	`, tableName)

	var valueStrings []string
	for i, eid := range req.GetExtensions() {
		valueString := fmt.Sprintf("('%s', %d)", eid, i)
		valueStrings = append(valueStrings, valueString)
	}
	values := strings.Join(valueStrings, ",")

	if err := s.db.Exec(sql, values, req.GetCategoryID()).Error; err != nil {
		return nil, errors.Wrapf(err, "error executing sql `%s` with values '%v' and category id %s", sql, values, req.GetCategoryID())
	}

	return &cat, nil
}
